//------------------------------------------------------------------------------
// File: FireTutorial.cs
// Controls the fire tutorial task and its vertex methods
// Author: Matthew Rudge
//------------------------------------------------------------------------------

//-Fire Tutorial Entry and Exit Functions---------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Activates the fire tutorial task
////////////////////////////////////////////////////////////////////////////////
function startFireTutorialTasks()
{
   InitializeQuestGui();
   tsStartTask("FireTutorial", tsGetStartingVertexes("FireTutorial"));
   tsEnableCommand("BuildCmdData", false);
   tsEnableCommand(DemolishCmdData, false);
   
   // disable the quit scenario button
   $DisableQuitScenario = true;
}

function winFireTutorial()
{
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(HeroCharacter, "5 experience");
   //Starts fire disasters on Main map
   TaskModifier.strMarkVertex("MainmapTasks", "DisastersMedTrigger", $TSV_AVAIL);   
}

////////////////////////////////////////////////////////////////////////////////
//! Deactivates the fire tutorial task
////////////////////////////////////////////////////////////////////////////////
function quitFireTutorialTasks()
{
   tsEnableCommand("BuildCmdData", true);
   tsEndTask("FireTutorial");
}
//------------------------------------------------------------------------------

//-FireInit Vertex--------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// The FireInit vertex is designed to give the introductory dialog explaining
// why you are here and monitor when the hero enters the zone. Once the zone is
// entered, then this vertex will ramp the percentage of fire disaster 
// occurrence to one-hundred percent.
////////////////////////////////////////////////////////////////////////////////
function FireInit::onEnter(%this)
{
   // Send intro dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_FIRETUT", "id_firetut_intro", $TaskButton::More, "firedude");
}

function FireInit::onExit(%this)
{   
   // Convert log cabin to player team
   tsConvertObjTeam("firecabin", $OST_PLAYER);
   tsConvertObjTeam("firewell", $OST_PLAYER);
   
   // Ramp fire percentage to 100 percent
   %scenario = new SLScenario() {
      stack = true;
      disasterFireRate = "100 5";
   };
   
   // Set up the fire disaster that will be used
   %fireDisaster = new SLFireScenario() {
      chance = 100;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 1;
      spreadTime = 15;
      spreadChance = 30;
      spreadRadius = 25;
      spreadStrength = 4;
      
      burnTime = 17;
      burnStrength = 1;
      burnMax = 3;
      
      // does no damage
      damageTime = 0.1;
      damageStrength = 0.2;
   };
   
   // Update the scenario to include fires
   %scenario.disasterFireScenario = %fireDisaster;
   LoadScenario(%scenario);
   
   // Force a disaster to occur
   DisasterManager.OnCreateDisaster();
   
   // Start building hp check vertex
   TaskModifier.markVertex(%this.getTaskId(), FireBurn.getVertexId(), $TSV_AVAIL);
}

//------------------------------------------------------------------------------

//-FireCheck Vertex-------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// The FireCheck vertex's purpose is to monitor the moment when the building 
// catches fire. Once it catches on fire, then there will be a dialog from the
// male civilian explaning how to put out the fire.
////////////////////////////////////////////////////////////////////////////////
function FireCheck::onUpdate(%this)
{
   // If the target building is on fire then complete this vertex
   %cmpBldg = slgQueryInterface("firecabin", $CID_BUILDING);
   if(%cmpBldg.onFire()) {
      tsCompleteVertexes("FireTutorial", "FireCheck");
   }
}

function FireCheck::onExit(%this)
{
   // Explain how to put out fires
   tsSendTaskPopUpDlg("ID_TASKNAME_FIRETUT", "id_firetut_explain", $TaskButton::Okay, "firedude");
   
   // Push quest logs for task
   //tsAddQuestToTracker
}
//------------------------------------------------------------------------------

//-FireExtinguish Vertex--------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex exists to monitor when the fire is extinguished. It also updates
// the health of the building so that it is never destroyed. Two dialogs appear
// when the fire is extinguished
////////////////////////////////////////////////////////////////////////////////
function FireExtinguish::onUpdate(%this)
{   
   // If the fire has been extinguished then complete this vertex
   %cmpBldg = slgQueryInterface("firecabin", $CID_BUILDING);
   if(!%cmpBldg.onFire()) {
      tsCompleteVertexes("FireTutorial", "FireExtinguish");
   }
}

function FireExtinguish::onExit(%this)
{
   // Give congratulations text and text to return to town or stay here
   tsSendTaskPopUpDlg("ID_TASKNAME_FIRETUT", "id_firetut_congrat", $TaskButton::Okay, "firedude");
   tsSendTaskClickDlg("ID_TASKNAME_FIRETUT", "id_firetut_return", $TaskButton::Accept, "firedude", "id_firetut_return");
   
   // Update quest logs for task
}
//------------------------------------------------------------------------------

//-FireExit Vertex--------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex marks when the player clicks accept on the exit dialogue and 
// takes the player back to the main map scenario
////////////////////////////////////////////////////////////////////////////////
function FireExit::onExit(%this)
{
   tsCompleteVertexes("FireTutorial", "FireBurn");
    %scenario = new SLScenario() {
      stack   = false;
      mapMain = false;
   };
   LoadScenario(%scenario, quitFireTutorialTasks, winFireTutorial);
}
//------------------------------------------------------------------------------

//-FireBurn Vertex--------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// This vertex exists to monitor and update the health of the building so that
// it is never destroyed. 
////////////////////////////////////////////////////////////////////////////////
function FireBurn::onUpdate(%this)
{
   // Keep building at maximum health
   %halfHealth = firecabin.getMaxHealth() / 2;
   if (firecabin.health < %halfHealth) {
      firecabin.health = %halfHealth;
   }
}
//------------------------------------------------------------------------------
// End FireTutorial.cs
